﻿uses
  Common, DataEntry, DataStorage, Regex, SysUtils;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
var
  theFileDriverInfo: TFileTypeInformation;
begin
  Result := -1; // Exclude
  if assigned(anEntry) then
  begin
    theFileDriverInfo := anEntry.DeterminedFileDriverInfo;
    if (theFileDriverInfo.ShortDisplayName <> null) and (trim(theFileDriverInfo.ShortDisplayName) <> '') then
    begin
      if RegexMatch(theFileDriverInfo.ShortDisplayName, '^(Word|Excel|PowerPoint|DocX|XLSX|PPTX)$', False) then
        Result := 1; // Include
    end;
  end;
end;

begin

end.
